package gov.va.med.mhv.health.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "IMMUNIZATION_REACTIONS")
public class ImmunizationReaction implements Serializable{

	private static final long serialVersionUID = -3961492515040872444L;
	
    @Id
	@Column(name="REACTION_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	
	@Column(name="REACTION_TYPE_CODE")
	private String reactionTypeCode;
	
	
	@ManyToOne
	@JoinColumn(name="IMMUNIZATION_ID_SEQ")
	private Immunization immunization;


	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}


	public Integer getOplock() {
		return oplock;
	}


	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}


	public String getReactionTypeCode() {
		return reactionTypeCode;
	}


	public void setReactionTypeCode(String reactionTypeCode) {
		this.reactionTypeCode = reactionTypeCode;
	}


	public Immunization getImmunization() {
		return immunization;
	}


	public void setImmunization(Immunization immunization) {
		this.immunization = immunization;
	}


}
